<?php

// Code taken from a random opensource project on github
// https://github.com/filp/whoops/blob/master/src/Whoops/Run.php

class Code {

	/**
	 * Handles an exception, ultimately generating a Whoops error
	 * page.
	 *
	 * @param Exception $exception
	 */
	public function handleException(Exception $exception) {
		// Walk the registered handlers in the reverse order
		// they were registered, and pass off the exception
		$inspector = $this->getInspector($exception);

		for ($i = count($this->handlerStack) - 1; $i >= 0; $i--) {
			$handler = $this->handlerStack[$i];

			$handler->setRun($this);
			$handler->setInspector($inspector);
			$handler->setException($exception);

			$handlerResponse = $handler->handle($exception);

			if ($handlerResponse === Handler::LAST_HANDLER) {
				// The Handler has handled the exception in some way,
				// or signals that no further handlers should be queried,
				// but the script execution will continue
				break;
			} elseif ($handlerResponse === Handler::QUIT) {
				// The Handler has handled the exception in some way,
				// and script execution should terminate, unless specifically
				// disallowed, in which case the behavior is the same as
				// Handler::LAST_HANDLER
				if ($this->allowQuit()) {
					exit;
				} else {
					break;
				}
			}
		}
	}

}

?>
